/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph.vecvoice;

import frc.emul.periph.vecvoice.Phonem;
import frc.emul.util.Utils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class Phonemes {
    public static final String DATA_FILE = "data/packs/phonems.jvepak";
    private static final byte DATAFORMAT_VERSION = 1;
    private static final String DATAFILE_HEADER = "ParaJVE/samples/vecvoice\u0001";
    public static final int DATASTREAM_RAW = 1;
    public static final int DATASTREAM_GZIP = 2;
    private static Phonem[] phonems;
    private static int sampleBits;

    public static final void main(String[] stringArray) throws IOException {
        Phonemes.loadSamples(16);
        int n = 0;
        while (n < 64) {
            System.out.println(" " + phonems[n].getName() + "\t -> " + phonems[n].getDataLength(1) / 2 + " bytes");
            ++n;
        }
    }

    public static final byte[] getFileHeader(int n) {
        return (DATAFILE_HEADER + (char)n).getBytes();
    }

    public static final Phonem getPhonem(int n) {
        return phonems[n];
    }

    public static final int getIndex(String string) {
        int n = phonems.length;
        while (n-- > 0) {
            if (!phonems[n].getName().equals(string)) continue;
            return n;
        }
        return -1;
    }

    public static final void loadSamples(int n) {
        if (phonems == null || sampleBits != n) {
            try {
                Phonemes.loadSamplesImpl(n);
                sampleBits = n;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error while loading phonems table", exception);
            }
        }
    }

    private static final void loadSamplesImpl(int n) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(Utils.getResourceStream(DATA_FILE));
        try {
            phonems = Phonemes.loadSamplesImpl(bufferedInputStream, n);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {}
    }

    private static final Phonem[] loadSamplesImpl(InputStream inputStream, int n) throws IOException {
        Phonem[] phonemArray;
        block22: {
            FilterInputStream filterInputStream = null;
            try {
                if (!Utils.checkHeader(inputStream, DATAFILE_HEADER.getBytes())) {
                    throw new IOException("The phonemes file header is invalid.");
                }
                switch (inputStream.read()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        inputStream = new GZIPInputStream(inputStream);
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported data stream mode!");
                    }
                }
                filterInputStream = new DataInputStream(inputStream);
                Phonem[] phonemArray2 = new Phonem[64];
                byte[] byArray = new byte[5];
                int n2 = 0;
                while (n2 < phonemArray2.length) {
                    ((DataInputStream)filterInputStream).read(byArray, 0, 4);
                    String string = new String(byArray);
                    string = string.substring(0, string.indexOf(0));
                    phonemArray2[n2] = new Phonem(n2, string);
                    ++n2;
                }
                int[] nArray = new int[64];
                int n3 = 0;
                while (n3 < phonemArray2.length) {
                    nArray[n3] = ((DataInputStream)filterInputStream).readUnsignedShort();
                    ++n3;
                }
                if (n == 15) {
                    n3 = 0;
                    while (n3 < phonemArray2.length) {
                        int n4 = nArray[n3];
                        int[] nArray2 = new int[n4];
                        int n5 = 0;
                        while (n5 < n4) {
                            int n6;
                            nArray2[n5] = n6 = (filterInputStream.read() & 0xFF) * Short.MAX_VALUE / 255;
                            ++n5;
                        }
                        phonemArray2[n3].setData1(nArray2, 0, n4);
                        ++n3;
                    }
                } else if (n == 16) {
                    n3 = 0;
                    while (n3 < phonemArray2.length) {
                        int n7 = nArray[n3];
                        int[] nArray3 = new int[n7];
                        int n8 = 0;
                        while (n8 < n7) {
                            int n9 = filterInputStream.read() & 0xFF;
                            nArray3[n8] = (n9 << 8) - 32768;
                            ++n8;
                        }
                        phonemArray2[n3].setData1(nArray3, 0, n7);
                        ++n3;
                    }
                } else {
                    throw new IllegalArgumentException("Number of bits not supported : " + n);
                }
                phonemArray = phonemArray2;
                if (filterInputStream == null) break block22;
            }
            catch (Throwable throwable) {
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        return phonemArray;
    }
}

